<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 04. Jan. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * OpenDocumentAbstract class file. 
 * 
 * PHP versions 5
 *   
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: ContentDocument.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: ContentDocument.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */

/**
 * 
 */
require_once 'OpenDocumentPHP/content/body/BodyFragment.php';
require_once 'OpenDocumentPHP/global/FontFaceDeclFragment.php';
require_once 'OpenDocumentPHP/global/AutomaticStylesFragment.php';
require_once 'OpenDocumentPHP/content/ScriptsFragment.php';
require_once 'OpenDocumentPHP/util/AbstractDocument.php';

/**
 * ContentDocument class.
 *  
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */
class ContentDocument extends AbstractDocument {

	/**
	 * @var 		ScriptsFragment
	 * @access		private
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	private $scripts;
	
	/**
	 * @var 		FontFaceDeclFragment
	 * @access		private
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	private $fontfacedecl;
	
	/**
	 * @var 		AutomaticStylesFragment
	 * @access		private
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	private $automaticstyles;
	
	/**
	 * @var 		BodyFragment
	 * @access		private
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	private $body;
	
	/**
	 * Constructor method.
	 * 
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function __construct() 
	{
		parent :: __construct('office:document-content');
		// append ScriptFragment
		$this->scripts = new ScriptsFragment();
		$this->root->appendChild($this->scripts);
		// append FontFaceDeclFragment
		$this->fontfacedecl = new FontFaceDeclFragment();
		$this->root->appendChild($this->fontfacedecl);
		// append AutomaticStylesFragment
		$this->automaticstyles = new AutomaticStylesFragment();
		$this->root->appendChild($this->automaticstyles);
		// append BodyFramgent
		$this->body = new BodyFragment();
		$this->root->appendChild($this->body);
	}
	
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	public function setSpreadsheet() {		   
		$this->body->setSpreadsheet();
	}
	
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	public function setText() {
		$this->body->setText();
	}
	
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	public function getTable($name) {
		$table = $this->body->getNewTableFragment($name);
		return $table;
	}
	
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	public function getFontFaceDeclarations() {
		return $this->fontfacedecl;
	}
	
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	public function getBody() {
		return $this->body;
	}
	
	/**
	 * Loads a content document into this ContentDocument.
	 * 
	 * @access 	public
	 * @since 	0.5.2 - 26. Feb. 2007
	 */
	public function loadXML($source) {
		$ret = parent :: loadXML($source);
		if ($ret === true) {
			$this->root = $this->documentElement;
			$this->initXpath();
			$result = $this->xpath->query('/office:document-content');
			$tmp = $result;
			if ($tmp->length == 1) {
				$this->content = $tmp->item(0);
				$result = $this->xpath->query('/office:document-content/office:scripts');
				if ($result->length == 1) {
					$node = $result->item(0);
					$this->scripts = new ScriptsFragment($node);
				} else {
					$ret = false;
				}
				$result = $this->xpath->query('/office:document-content/office:font-face-decls');
				if ($result->length == 1) {
					$node = $result->item(0);
					$this->fontfacedecl = new FontFaceDeclFragment($node);
				} else {
					$ret = false;
				}
				$result = $this->xpath->query('/office:document-content/office:automatic-styles');
				if ($result->length == 1) {
					$node = $result->item(0);
					$this->automaticstyles = new AutomaticStylesFragment($node);
				} else {
					$ret = false;
				}
				$result = $this->xpath->query('/office:document-content/office:body');
				if ($result->length == 1) {
					$node = $result->item(0);
					$this->body = new BodyFragment($node);
				} else {
					$ret = false;
				}
			} else {
				// This should never happend!
				$ret = false;
			}
		}
		return $ret;
	}
	
	/**
	 * Retrieve automatic-style class
	 * 
	 * @access     public
	 * @return     AutomaticStyle The automatic-style class
	 * @since      0.5.3 - 02. Aug. 2007
	 */
    public function getAutomaticStyles() 
    {
        return $this->automaticstyles;        
    }
    
}
?>
